<?php

namespace App\Http\Middleware;

use App\Http\Resources\Web\TherapistCommunitysResource;
use App\Http\Resources\Web\CustomersResource;
use App\Http\Resources\Web\TherapistsResource;
use App\Models\CompanyPage;
use App\Models\Currency;
use App\Models\TherapistCommunity;
use App\Models\Customer;
use App\Models\Therapist;
use App\Models\Language;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inertia\Middleware;
use Tightenco\Ziggy\Ziggy;
use Illuminate\Support\Facades\File;
class HandleInertiaRequests extends Middleware
{
    /**
     * The root template that is loaded on the first page visit.
     *
     * @var string
     */
    protected $rootView = 'app';

    /**
     * Determine the current asset version.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return string|null
     */
    public function version(Request $request)
    {
        return parent::version($request);
    }

    /**
     * Define the props that are shared by default.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function share(Request $request)
    {

         if (!File::exists(storage_path('installed'))) {
                 return array_merge(parent::share($request), [
             ]);
        }
        $languages = Language::active()->get();
        $locale = app()->getLocale();
        $company_pages = CompanyPage::active()->notDefault()->get();
        $all_company_pages = [];
        foreach ($company_pages as $company_page) {
            $temp['name'] = $company_page->getTranslation('name' , session()->get('locale') ?? app()->getLocale());
            $temp['heading'] = $company_page->getTranslation('heading' , session()->get('locale') ?? app()->getLocale());
            $temp['description'] = $company_page->getTranslation('description' , session()->get('locale') ?? app()->getLocale());
            $temp['slug'] = $company_page->slug;
            $all_company_pages[] = $temp;
        }
        $user = Auth::user();
        $logged_in_as = $request->session()->get('logged_in_as');
        if($logged_in_as == 'therapist'){
            config(['cashier.model' => 'App\Models\Therapist']);
            $therapist = Therapist::withAll()->where('id',$user->therapist->id)->first();
            if($therapist->pricing_plan){
                $pricing_plan = $therapist->pricing_plan;
                $therapist_modules = $pricing_plan->therapist_modules()->pluck('pricing_plan_modules.module_code')->toArray();
            }else{
                $therapist_modules = [];
            }
            $login_info = new TherapistsResource($therapist);
        }else if($logged_in_as == 'therapist_community'){
            config(['cashier.model' => 'App\Models\TherapistCommunity']);
            $therapist_community = TherapistCommunity::withAll()->where('id',$user->therapist_community->id)->first();
            if($therapist_community->pricing_plan){
                $pricing_plan = $therapist_community->pricing_plan;
                $therapist_community_modules = $pricing_plan->therapist_community_modules()->pluck('pricing_plan_modules.module_code')->toArray();
            }else{
                $therapist_community_modules = [];
            }
            $login_info = new TherapistCommunitysResource($therapist_community);
        }else if($logged_in_as == 'customer'){
            $customer = Customer::withAll()->where('id',$user->customer->id)->first();
            $login_info = new CustomersResource($customer);
        }
        else{
            $login_info = null;
        }
        $all_pages_content = pagesTranslations();
        $settings = unProtectedGeneralSettings();

        return array_merge(parent::share($request), [
            'locale' => function () {
                return app()->getLocale();
            },
            'flash' => [
                'alert' => $request->session()->get('alert'),
                'status' => $request->session()->get('status')
            ],
            'response_data' => $request->session()->get('response_data'),
            'translation_languages' => $languages,
            'default_currency' => Currency::where('is_default',1)->first(),
            'company_pages' => $all_company_pages,
            'all_pages_content' => $all_pages_content,
            'language' => function () {
                return translations(
                    resource_path('lang/' . app()->getLocale() . '.json')
                );
            },
            'settings' => $settings,
            'auth' => $user ? [
                'user' => $user,
                'roles' => $user->roles()->pluck('roles.role_code')->toArray(),
                'therapist_modules' => $therapist_modules ?? [],
                'therapist_community_modules' => $therapist_community_modules ?? [],
                $logged_in_as => $login_info,
                'logged_in_as' => $request->session()->get('logged_in_as')
            ] : null
        ]);
    }
}
